import os
import shutil
import unittest


class TestCase(unittest.TestCase):
    def setUp(self):
        pass

    def tearDown(self):
        try:
            shutil.rmtree('/var/run/xend/boot')
        except:
            pass

    def test_cli(self):
        self.assertTrue(os.system('./xenpvboot'))
        self.assertFalse(os.system('./xenpvboot -h'))
        self.assertFalse(os.system('./xenpvboot -q nfs:10.182.120.78:/share/iso/el5/u4/i386'))
        self.assertFalse(os.system('./xenpvboot -q nfs:10.182.120.78:/share/iso/el5/u4/i386/'))
        self.assertTrue(os.system('./xenpvboot -q nfs:10.182.120.78:/share/iso/el5/u4'))
        self.assertFalse(os.system('./xenpvboot -q --kernel i386/images/xen/vmlinuz --ramdisk i386/images/xen/initrd.img nfs:10.182.120.78:/share/iso/el5/u4'))
        self.assertFalse(os.system('./xenpvboot -q nfs+iso:10.182.120.78:/share/iso/el5/u4/Enterprise-R5-U4-Server-i386-dvd.iso'))
        self.assertFalse(os.system('./xenpvboot -q file:///share/iso/el5/u4/i386'))
        self.assertFalse(os.system('./xenpvboot -q /share/iso/el5/u4/i386'))
        self.assertFalse(os.system('./xenpvboot -q /share/iso/el5/u4/Enterprise-R5-U4-Server-i386-dvd.iso'))
        #self.assertFalse(os.system('./xenpvboot -q --kernel iso/el5/u4/i386/images/xen/vmlinuz --ramdisk iso/el5/u4/i386/images/xen/initrd.img /dev/sdb1'))
        self.assertFalse(os.system('./xenpvboot -q http://10.182.120.78/share/iso/el5/u4/i386'))
        self.assertFalse(os.system('./xenpvboot -q --kernel i386/images/xen/vmlinuz --ramdisk i386/images/xen/initrd.img http://10.182.120.78/share/iso/el5/u4'))
        self.assertFalse(os.system('./xenpvboot -q ftp://10.182.120.78/share/iso/el5/u4/i386'))
        self.assertFalse(os.system('./xenpvboot -q --kernel i386/images/xen/vmlinuz --ramdisk i386/images/xen/initrd.img ftp://10.182.120.78/share/iso/el5/u4'))
        self.assertFalse(os.system('./xenpvboot -q tftp://10.182.120.78/share/iso/el5/u4/i386'))
        self.assertFalse(os.system('./xenpvboot -q tftp://10.182.120.78:69/share/iso/el5/u4/i386'))
        self.assertFalse(os.system('./xenpvboot -q --kernel i386/images/xen/vmlinuz --ramdisk i386/images/xen/initrd.img tftp://10.182.120.78/share/iso/el5/u4'))
        self.assertFalse(os.system('./xenpvboot -q --kernel /share/iso/el5/u4/i386/images/xen/vmlinuz --ramdisk /share/iso/el5/u4/i386/images/xen/initrd.img tftp://10.182.120.78'))
        self.assertFalse(os.system('./xenpvboot -q --kernel share/iso/el5/u4/i386/images/xen/vmlinuz --ramdisk share/iso/el5/u4/i386/images/xen/initrd.img tftp://10.182.120.78'))


if __name__ == '__main__':
    unittest.main()
