/**************************************************************************\
*//*! \file ef_bend_netdev.h

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

** </L5_PRIVATE>
*//*
\**************************************************************************/

#include <linux/netdevice.h>
#include <linux/skbuff.h>

/*! \brief Receive a packet on this interface
 *
 * Pass the received packet out of this network device into the xen
 * bridge/network stack.
 * 
 * \param bend The relevant back end driver data structure
 * \param skb The packet to receive
 * \return The return code of netif_rx()
 */
int ef_bend_netdev_recv(struct ef_bend *bend, struct sk_buff *skb);

/*! \brief Get a socket buffer and reserve "len" using skb_put 
 *  
 * The socket buffer is allocated using GFP_ATOMIC, so can be called
 * from atomic.
 *
 * \param len The length of payload 
 * \param skb A pointer to a skb structure pointer
 * \return A pointer to the payload's location; skb is now pointing to
 * the socket buffer structure
 */
void *ef_bend_netdev_get_skb(int len, struct sk_buff **skb);

/*! \brief Start things off
 * 
 * Allocates and initialises a net_device, and registers it with the
 * OS.
 *
 * \param bend The relevant back end driver structure
 * \return 0 on success, -ENOMEM if no memory available for internal
 * data structures
 */
int ef_bend_netdev_probe(struct ef_bend *bend);

/*! \brief Shut things down.
 * 
 * Frees the memory and unregisters the device allocated using
 * ef_bend_netdev_probe.  If no net_device is found, it silently returns.
 *
 * \param bend The relevant back end driver data structure
 * \return Nothing
 */
void ef_bend_netdev_remove(struct ef_bend *bend);
