open Lwt
open Irmin_unix

let opt_eq x = function
  | None -> None = x
  | Some v -> v = x

module ImapContents = 
  struct
    include Irmin.Contents.String

    let equal a b = 
      Printf.printf "equql %s %s\n%!" a b; false

    let merge path ~old x y =
      let open Irmin.Merge.OP in
      Printf.printf "merging path: %s %b\n%!" (String.concat "/" path) (x = y);
      old () >>= function
      | `Conflict _ -> ok y
      | `Ok old ->
      if opt_eq x old then (
        ok y
      ) else if opt_eq y old then (
        ok x
      ) else (
        ok y 
      )
  end

let fetch remote local =
  let store = Irmin.basic (module Irmin_git.FS) (module ImapContents) in
  let config = Irmin_git.config ~root:local ~bare:true () in
  Irmin.create store config task >>= fun t ->
  let upstream = Irmin.remote_uri remote in
  Irmin.pull_exn (t "Syncing with upstream store") upstream `Merge

let () =
  Lwt_main.run (
    install_dir_polling_listener 0.5;
    catch (fun () -> fetch Sys.argv.(1) Sys.argv.(2))
        (fun ex -> Printf.printf "----- exception %s\n%!" (Printexc.to_string ex); return ())
  )
