(* 
    Socket for OCaml XenStore Daemon.
    Copyright (C) 2008 Patrick Colp University of British Columbia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(* Convert an int to a file descriptor *)
external file_descr_of_int : int -> Unix.file_descr = "%identity"

(* Convert a file descriptor to an int *)
let int_of_file_descr fd = (Obj.magic (fd: Unix.file_descr) : int)

(* Socket interface *)
class socket_interface fd can_write in_set out_set =
object (self)
  inherit Interface.interface as super
  val m_fd = fd
  val m_can_write = can_write
  val m_in_set = in_set
  val m_out_set = out_set
  method private fd = m_fd
  method private in_set = !m_in_set
  method private out_set = !m_out_set
  method can_read = List.mem self#fd self#in_set
  method can_write = can_write
  method destroy = Unix.close self#fd
  method read buffer offset length =
    let bytes_read = Unix.read self#fd buffer offset length in
    if bytes_read = 0 && length <> 0
    then raise (Constants.Xs_error (Constants.EIO, "socket_interface#read", "could not read data"))
    else bytes_read
  method write buffer offset length = Unix.write self#fd buffer offset (min length (String.length buffer))
end
