/**************************************************************************\
*//*! \file ef_bend_accel.c Generic interface to the H/W acceleration

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2,
as published by the Free Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *//*
\**************************************************************************/

#include "ef_bend.h"
#include "ci/xen/ef_msg_iface.h"
#include "ef_bend_accel.h"


static int setup_dummy_accel(struct ef_bend *bend)
{
  struct ef_msg msg;
  int err;
  ci_log("We apologise for the inconvenience.");
  ef_msg_init(&msg, EF_MSG_SETHW);
  msg.u.hw.type = bend->hw_type;
  err = ef_msg_send_notify(bend->shared_page, bend->channel,
                           &bend->to_domU, &msg);
  return err;
}

static void shutdown_dummy_accel(struct ef_bend *bend)
{
}

/* It would be tidier (and more entertaining) to do this by putting all the
 * init and shutdown stuff in a linker section, but that would involve
 * patching the linker script, which might not be accepted */
#ifdef HAVE_SOLARFLARE_ACCEL
extern int ef_sf_accel_init(void);
extern void ef_sf_accel_shutdown(void);
int ef_sf_accel_hwtype(struct ef_bend *bend);
#endif

int ef_bend_accel_init()
{
  int rc = 0;
#ifdef HAVE_SOLARFLARE_ACCEL
  rc = ef_sf_accel_init();
#endif
  return rc;
}

void ef_bend_accel_shutdown()
{
#ifdef HAVE_SOLARFLARE_ACCEL
  ef_sf_accel_shutdown();
#endif
}

int ef_bend_hwtype(struct ef_bend *bend)
{
  int rc = -ENOENT;
  if (!bend->unaccelerated) {
#ifdef HAVE_SOLARFLARE_ACCEL
  rc = ef_sf_accel_hwtype(bend);
#endif
  }
  if (rc == -ENOENT) {
    bend->hw_type = MSG_HWTYPE_NONE;
    bend->accel_setup = setup_dummy_accel;
    bend->accel_shutdown = shutdown_dummy_accel;
    rc = 0;
  }
  return rc;
}
