/**************************************************************************\
*//*! \file ef_iputil.c IP utility functions

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 *//*
\**************************************************************************/

#include "ef_filter.h"

#ifdef __linux__
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>

#define EF_PROTO_UNKNOWN (-1)
#define EF_PROTO_TCP IPPROTO_TCP
#define EF_PROTO_UDP IPPROTO_UDP


inline static void ef_iphdr_to_filt(__u8 *data, struct ef_filter_spec *spec)
{
  /* The packet we have received from driverlink has already had the 
   * h/w header pulled. */

  struct iphdr *ip = (struct iphdr *)data;
  spec->proto = ip->protocol;
  spec->destip_be = ip->daddr;
  spec->eviction_notice = NULL;

  if (ip->protocol == IPPROTO_TCP) {
    struct tcphdr *tcp = (struct tcphdr *)((char *)ip + 4 * ip->ihl);
    spec->destport_be = tcp->dest;
  } else {
    struct udphdr *udp = (struct udphdr *)((char *)ip + 4 * ip->ihl);
    spec->destport_be = udp->dest;
  }
}

#else
#error Please add support for your OS
#endif

