/**************************************************************************\
*//*! \file ef_char_bend.h Xen back end driver/EF resources

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 *//*
\**************************************************************************/
#ifndef EF_CHAR_BEND_H
#define EF_CHAR_BEND_H

/* This is our interface to the resource manager. */
#include <ci/driver/efab/internal.h>

#include "ci/xen/ef_msg_iface.h"
struct efab_resource_s;
struct ef_eventq_struct;

/* States of resource allocation we can go through */
/*! No hardware has yet been allocated. */
#define EF_RES_NONE  (0)
/*! Hardware has been allocated and given to far end. */
#define EF_RES_ALLOC (1)
/*! Hardware has been allocated, far end is no longer using it. */
#define EF_RES_DONE  (2)

/*! Allocate the hardware resources, encode them in a
 * message and send them to the far end. 
 * \param bend : the backend to initialise
 * \return 0 on success, or -errno 
 */
extern int ef_bend_setup_vnic_hw(struct ef_bend *bend);

/*! Shudown and release the hardware resources for a
 * bend
 * \param bend : the backend to initialise
 */
extern void ef_bend_shutdown_vnic_hw(struct ef_bend *bend);

/*! Allocate the hardware resources corresponding to a VNIC 
 * \param bend : the backend for which the H/W is wanted
 * \return 0 on success, or -errno 
*/
extern int ef_get_vnic(struct ef_bend *);

/*! Package the low-level details of the hardware into a message
 * \param bend : the backend that has the H/W
 * \param msg : ef_msg_hw structure to fill out
 * \return 0 on success, or -errno 
 */
extern int ef_bend_hwinfo(struct ef_bend *bend, struct ef_msg_hw *mgs);

/*! Release all hardware resources for the VNIC
 * \param bend : the backend that has the H/W
*/
extern void ef_free_vnic(struct ef_bend *bend);

/*! Allocate a set of NIC buffers 
 * \param bend : backend the allocation is for
 * \param pages : on entry, number of pages of buffer space wanted, on exit num allocated
 * \param memaddrs : returned KVAs of allocated pages
 * \param bufaddr : return NIC buffer address of allocation
 * \return 0 on success, or -errno. Note that allocation of fewer pages than
 * requested due to quota enforcement is not an error */
extern int ef_get_bufs(struct ef_bend *bend, int *pages, 
                       void **memaddrs,
                       __u32 *bufaddr);

/*! Allocate a filter resource.
 * \param pthandle : handle to the pt the filter delivers to
 * \param fres_out : returned filter resource
 * \return 0 on success, or -errno
*/
extern int ef_char_alloc_filter(efab_resource_handle_t pthandle,
                         filter_resource_t **fres_out);

/*! Free a filter resource
 * \param fres : the resource to free
*/
extern void ef_char_free_filter(filter_resource_t *fres);

/*! Allocate a portion of the NIC buffer table */
int ef_bend_buffer_table_alloc(unsigned order, 
                               efab_buffer_table_allocation *bt_handle);

/*! Set a portion of the NIC buffer table */
int ef_bend_buffer_table_set(struct ef_bend *bend, int mfn, int offset,
                             efab_buffer_table_allocation *bt_handle);

extern int ef_sf_accel_init(void);
extern void ef_sf_accel_shutdown(void);
extern int ef_bend_char_init(void);
extern void ef_bend_char_shutdown(void);
#define EF_FUNC_PTR(_name) typeof(&_name) fn_ ##_name
extern EF_FUNC_PTR(efab_filter_resource_clear);


#endif
