/**************************************************************************\
*//*! \file ef_msg_util.c Wrappers around Xen APIs

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 *//*
\**************************************************************************/

#ifndef EF_XEN_UTIL
#define EF_XEN_UTIL

/* Rename xen constants for generic use */
#define EF_HYPEROP_READWRITE  IOMEM_ACCESS_READWRITE 
#define EF_HYPEROP_READONLY   IOMEM_ACCESS_READONLY 

struct ef_hyperop_mapping;

/* Map a set of grants to be virtually contiguous */
extern void *ef_map_grants_contig(struct xenbus_device *dev, 
                                  unsigned *grants, 
                                  int npages,
                                  struct ef_hyperop_mapping**priv);

extern int xen_net_read_mac(struct xenbus_device *dev, u8 mac[]);
#endif
