#!/usr/bin/env python


import os
command = 'nm -s %s'

class SymbolTable(dict):
    '''maps global symbol to virtual address'''
    def loadSymbolFromObjectFile(self, filename):
        """load symbols and addresses from file's symbol tables, this calls nm command."""
        f = os.popen(command % filename)
        lines = f.readlines()
        for line in lines:
            try:
                addr, _, name = line.split(' ')
            except:
                continue
            addr = int(addr, 16)
            name = name[:-1]
            self.__setitem__(name, addr)


if __name__ == '__main__':
    st = SymbolTable()
    st.loadSymbolFromObjectFile('xen-syms')
    print 'idld_pg_table: ', hex(st['idle_pg_table'])
    print 'dom0: ', hex(st['dom0'])
