import struct
import Register
import StringIO

class BaseXenContext(object):
    def __init__(self, dwarf, context=None):
        self.dwarf = dwarf

        if context:
            self.context = context
        else:
            self.context = "\x00" * self.ctxt_size

        self.ctxtf = StringIO.StringIO(self.context)

    def __str__(self):
        return self.ctxtf.getvalue()

    def clone(self):
        return self.__class__(self.dwarf, self.ctxtf.getvalue())
        
    def set_register(self, reg):
        regstr = reg.asXen()

        self.ctxtf.seek(self.reg_offset)
        self.ctxtf.write(regstr)

    def get_register(self):
        self.ctxtf.seek(self.reg_offset)
        regstr = self.ctxtf.read(self.reg_size)
        reg = self.register
        reg.fromXen(regstr)
        return reg

    def set_ctrlreg(self, num, val):
        if num > self.max_ctrlreg or num < 0:
            raise IndexError

        regstr = struct.pack(self.ctrlreg_format, val)
        self.ctxtf.seek(self.ctrlreg_offset + self.ctrlreg_size * num)
        self.ctxtf.write(regstr)
        
    def get_ctrlreg(self, num):
        if num > self.max_ctrlreg or num < 0:
            raise IndexError
        
        self.ctxtf.seek(self.ctrlreg_offset + self.ctrlreg_size * num)
        regstr = self.ctxtf.read(self.ctrlreg_size)
        return struct.unpack(self.ctrlreg_format, regstr)


class XenContext_x86_32(BaseXenContext):
    def __init__(self, dwarf, context=None):
        self.dwarf = dwarf
        self.ctxt_size = dwarf.get_struct_size('vcpu_guest_context')
        self.reg_offset = dwarf.calc_struct_member_offset('vcpu_guest_context', 'user_regs') 
        self.reg_size =  dwarf.get_struct_size('cpu_user_regs') 
        self.ctrlreg_offset = dwarf.calc_struct_member_offset('vcpu_guest_context', 'ctrlreg')
        self.ctrlreg_format = 'L'
        self.ctrlreg_size = struct.calcsize('L')
        self.max_ctrlreg = 7            # 0-7
        self.register = Register.Register('x86_32')

        BaseXenContext.__init__(self, dwarf, context)

        
arch = {'x86_32': XenContext_x86_32,
        'x86_32pae': XenContext_x86_32,
        # 'x86_64': XenContext_x86__64,
        # 'ia64': XenContext_x86__64,
        }

def XenContext(archname, dwarf, context):
    return arch[archname](dwarf, context)
