import Arch
import struct

class CoreDump:
    '''core dump file interface class'''
    def __init__(self, corefilename, arch):
        self.corefilename = corefilename
        self.arch = Arch.arch[arch]

    def read_page(self, mfn):
        '''return a page data'''
        raise NotImplementedError

    def write_page(self, mfn, data):
        '''write a page data'''
        raise NotImplementedError

    def has_page(self, mfn):
        '''return a page is there or not'''
        raise NotImplementedError

    def get_pagelist(self):
        '''return a list of all available mfn'''
        raise NotImplementedError

    def read_addr(self, maddr, size):
        '''read 'size' bytes data from address'''

        start_mfn = self.arch.maddr_to_mfn(maddr)
        end_mfn = self.arch.maddr_to_mfn(maddr + size)
        offset = self.arch.page_offset(maddr)
        data = ''

        for mfn in range(start_mfn, end_mfn + 1):
            data += self.read_page(mfn)

        return data[offset:offset+size]

    def read_struct(self, maddr, format):
        '''read struct data from address, structure is set by format string'''

        data = self.read_addr(maddr, struct.calcsize(format))
        return struct.unpack(format, data)

    
