
class Arch:
    def __init__(self, name, page_shift, pt_format):
        self.name = name
        self.page_shift = page_shift
        self.page_size = 1 << page_shift
        self.pagemask = (1 << page_shift) - 1
        self.pt_format = pt_format

    def maddr_to_mfn(self, maddr):
        '''return mfn from maddr'''
        return maddr >> self.page_shift
        
    def mfn_to_maddr(self, mfn):
        '''return maddr from mfn'''
        return mfn << self.page_shift

    def page_offset(self, maddr):
        '''return offset in page'''
        return maddr & self.pagemask

    def round_pgup(self, size):
        '''return size round by pagesize'''
        return ((size + (self.page_size -1)) / self.page_size) * self.page_size



x86_32 = Arch('x86_32', 12, 'L')
x86_64 = Arch('x86_64', 12, 'Q')
ia64 = Arch('ia64', 14, 'Q')

arch = {'x86_32': x86_32,
        'x86_64': x86_64,
        'ia64': ia64,
        }
